import { GoogleGenAI } from "@google/genai";
import { Product, Invoice } from "../types";

const ai = new GoogleGenAI({ apiKey: process.env.API_KEY });

export const getInventoryAnalysis = async (products: Product[], invoices: Invoice[]): Promise<string> => {
  try {
    // Simplify data to save tokens and focus on analysis
    const inventorySummary = products.map(p => ({
      name: p.name,
      stock: p.stock,
      price: p.price,
      cost: p.cost,
      profit_margin: p.price - p.cost
    }));

    const salesSummary = invoices.slice(-10).map(inv => ({
      date: inv.date,
      total: inv.finalAmount,
      items: inv.items.length
    }));

    const prompt = `
      بصفتك خبيرًا في إدارة الأعمال والمخزون، قم بتحليل البيانات التالية لمتجر تجزئة:
      
      المخزون الحالي:
      ${JSON.stringify(inventorySummary)}

      آخر المبيعات:
      ${JSON.stringify(salesSummary)}

      المطلوب:
      قدم 3 نصائح استراتيجية قصيرة ومحددة (باللغة العربية) لتحسين الربحية وإدارة المخزون. ركز على المنتجات الراكدة، هوامش الربح، أو اتجاهات المبيعات.
      نسق الإجابة كنقاط واضحة.
    `;

    const response = await ai.models.generateContent({
      model: "gemini-2.5-flash",
      contents: prompt,
    });

    return response.text || "لم أتمكن من توليد تحليل في الوقت الحالي.";
  } catch (error) {
    console.error("Gemini API Error:", error);
    return "حدث خطأ أثناء الاتصال بالمساعد الذكي. يرجى التحقق من مفتاح API.";
  }
};
